%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Analyze data regarding link-properties of IEEE 802.11b;
%
% Save data by: distance, packet-size, & packet-type
%
%
% Author: Hongwei Zhang (zhangho@cse.ohio-state.edu
% Date: Nov. 8, 2004 -
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear
clc

%constants
USE_UNIX_MATLAB = 0;%1; %0: no     1: yes
if ~USE_UNIX_MATLAB
    %rootDir = 'D:\Hongwei\RESEARCH\NEST\ExScal\Tier2-messaging\link-properties\osu-airport\3ft-separation\organizedData';
    %rootDir = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\unicast-0\organizedData';
    %rootDir = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\broadcast-0\organizedData';
    %rootDir = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\broadcast-1\organizedData';
    %rootDir = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\broadcast-power2\organizedData';
    rootDir = 'F:\Hongwei\RESEARCH\data\LOF-SN\link-properties\kansei\broadcast-power1\organizedData';
else 
    %rootDir = '/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/osu-airport/3ft-separation/organizedData';
    %rootDir = '/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/osu-airport/12-and-6-ft-separation/organizedData';
    %rootDir = '/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/1km-135ft-separation/organizedData';
    %rootDir = '/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/1km-135ft-separation/unicast-0-retry/organizedData';
    %rootDir = '/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/Avon-park/broadcast/organizedData';
    %rootDir = '/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/Avon-park/unicast/organizedData';
    %rootDir = '/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/testbed-attenuator/40db/power-127/organizedData';
    %rootDir = '/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/testbed-attenuator/40db/power-128/organizedData';
    %rootDir ='/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/kansei/unicast/row7/organizedData';
    %rootDir ='/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/kansei/unicast/otherRows/organizedData';
    %rootDir ='/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/kansei/broadcast/organizedData';    
    %rootDir ='/home/6/anish/ft/zhang/zhangho/RESEARCH/NEST/ExScal/Tier2-messaging/link-properties/kansei/broadcast/30bytes/organizedData';
    %rootDir ='/home/6/anish/ft/zhang/NEST-1/ExScal/Tier2-messaging/link-properties/kansei/broadcast/diffPowerLevels/organizedData';
    %rootDir = '/home/6/anish/ft/zhang/NEST-0/Tier-1/Hongwei/ExScalMessaging/LinkMeasurement/exptData/kansei/2/organizedData';
end
%ORGNIZED_FILE_PREFIX = 'link_data_3ft';
%ORGNIZED_FILE_PREFIX = 'link_data_12_and_6_ft';
%ORGNIZED_FILE_PREFIX = '1km-135ft-separation';
%ORGNIZED_FILE_PREFIX = 'avon-park-broadcast-interferer-free';
%ORGNIZED_FILE_PREFIX = 'avon-park-broadcast-with-interferer';
%ORGNIZED_FILE_PREFIX = 'avon-park-unicast-interferer-free';
%ORGNIZED_FILE_PREFIX = 'avon-park-unicast-with-interferer';
%ORGNIZED_FILE_PREFIX = 'testbed-40db-power-127';
%ORGNIZED_FILE_PREFIX = 'testbed-40db-power-128';
%ORGNIZED_FILE_PREFIX = 'kansei-unicast-interferer-free';
%ORGNIZED_FILE_PREFIX = 'kansei-unicast-interfer-sym';
%ORGNIZED_FILE_PREFIX = 'kansei-unicast-interfer-far';
%ORGNIZED_FILE_PREFIX = 'kansei-unicast-interfer-middle';
%ORGNIZED_FILE_PREFIX = 'kansei-unicast-interfer-close';
%ORGNIZED_FILE_PREFIX = 'kansei-unicast-interfer-all';
%ORGNIZED_FILE_PREFIX = 'kansei-unicast-interfer-exscal';
%ORGNIZED_FILE_PREFIX = 'kansei-unicast-other-rows-row1';
%ORGNIZED_FILE_PREFIX = 'kansei-unicast-other-rows-row2';
%ORGNIZED_FILE_PREFIX = 'kansei-unicast-other-rows-row3';
%ORGNIZED_FILE_PREFIX = 'kansei-unicast-other-rows-row4';
%ORGNIZED_FILE_PREFIX = 'kansei-unicast-other-rows-row5';
%ORGNIZED_FILE_PREFIX = 'kansei-unicast-other-rows-row6';
%ORGNIZED_FILE_PREFIX = 'kansei-unicast-other-rows-row8';
%ORGNIZED_FILE_PREFIX = 'kansei-unicast-other-rows-row9';
%ORGNIZED_FILE_PREFIX = 'kansei-unicast-other-rows-row10';
%ORGNIZED_FILE_PREFIX = 'kansei-unicast-other-rows-row11';
%ORGNIZED_FILE_PREFIX = 'kansei-unicast-other-rows-row12';
%ORGNIZED_FILE_PREFIX = 'kansei-unicast-other-rows-row13';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-interfer-all';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-interferer-free';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-interfer-sym';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-interfer-far';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-interfer-middle';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-interfer-close';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-interfer-exscal';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-30bytes-interferer-free';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-diffPowerLevels-special-power128';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-diffPowerLevels-power148';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-diffPowerLevels-special-power208';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-diffPowerLevels-special-power42';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-diffPowerLevels-special-power62';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-diffPowerLevels-power148';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-diffPowerLevels-power168';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-diffPowerLevels-power188';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-diffPowerLevels-power208';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-diffPowerLevels-power228';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-diffPowerLevels-power248';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-diffPowerLevels-power2';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-diffPowerLevels-power22';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-diffPowerLevels-power42';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-diffPowerLevels-power82';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-diffPowerLevels-power102';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-diffPowerLevels-power122';
%ORGNIZED_FILE_PREFIX = 'kansei-broadcast-diffPowerLevels-power127';
%ORGNIZED_FILE_PREFIX = 'kansei-mote-broadcast-power3-data';
%ORGNIZED_FILE_PREFIX = 'kansei-mote-broadcast-power6-data';
%ORGNIZED_FILE_PREFIX = 'kansei-mote-broadcast-power9-data';
%ORGNIZED_FILE_PREFIX = 'kansei-xsm-unicast-power3-03-12-07a-noMacLatency';
%ORGNIZED_FILE_PREFIX = 'kansei-xsm-broadcast-power3-LM-xsm-interferer-free';
%ORGNIZED_FILE_PREFIX = 'kansei-xsm-broadcast-power3-LM-xsm-interferer-close';
%ORGNIZED_FILE_PREFIX = 'kansei-xsm-broadcast-power3-LM-xsm-interferer-middle';
%ORGNIZED_FILE_PREFIX = 'kansei-xsm-broadcast-power3-LM-xsm-interferer-far';
%ORGNIZED_FILE_PREFIX = 'kansei-xsm-unicast-power3-diagonal-12';
%ORGNIZED_FILE_PREFIX = 'kansei-xsm-broadcast-power3-interferer-free-diagonal-12';
%ORGNIZED_FILE_PREFIX = 'kansei-xsm-unicast-power3-LM-xsm-unicast-12-free';
%ORGNIZED_FILE_PREFIX = 'kansei-xsm-unicast-power3-LM-xsm-unicast-12-close';
%ORGNIZED_FILE_PREFIX = 'kansei-xsm-unicast-power3-LM-xsm-unicast-12-middle';
%ORGNIZED_FILE_PREFIX = 'kansei-xsm-unicast-power3-LM-xsm-unicast-12-far';
%ORGNIZED_FILE_PREFIX = 'kansei-xsm-broadcast-power3-xsm-interferer-free';
%ORGNIZED_FILE_PREFIX = 'kansei-xsm-broadcast-power3-xsm-interferer-close';
%ORGNIZED_FILE_PREFIX = 'kansei-xsm-broadcast-power3-xsm-interferer-middle';
%ORGNIZED_FILE_PREFIX = 'kansei-xsm-broadcast-power3-xsm-interferer-far';
%ORGNIZED_FILE_PREFIX = 'kansei-xsm-broadcast-power2-xsm-interferer-free';
ORGNIZED_FILE_PREFIX = 'kansei-xsm-broadcast-power1-xsm-interferer-free';

%DATA_PARSED_PREFIX = 'link_data_parsed_3ft';
%DATA_PARSED_PREFIX = 'link_data_parsed_1km-135ft-separation';
%DATA_PARSED_PREFIX = 'link_data_parsed_avon-park-broadcast-interferer-free';
%DATA_PARSED_PREFIX = 'link_data_parsed_avon-park-broadcast-with-interferer';
%DATA_PARSED_PREFIX = 'link_data_parsed_avon-park-unicast-interferer-free';
%DATA_PARSED_PREFIX = 'link_data_parsed_avon-park-unicast-with-interferer';
%DATA_PARSED_PREFIX = 'parsed_testbed-40db-power-127';
%DATA_PARSED_PREFIX = 'parsed_testbed-40db-power-128';
%DATA_PARSED_PREFIX = 'parsed_kansei-unicast-interferer-free';
%DATA_PARSED_PREFIX = 'parsed_kansei-unicast-interfer-sym';
%DATA_PARSED_PREFIX = 'parsed_kansei-unicast-interfer-far';
%DATA_PARSED_PREFIX = 'parsed_kansei-unicast-interfer-middle';
%DATA_PARSED_PREFIX = 'parsed_kansei-unicast-interfer-close';
%DATA_PARSED_PREFIX = 'parsed_kansei-unicast-interfer-all';
%DATA_PARSED_PREFIX = 'parsed_kansei-unicast-interfer-exscal';
%DATA_PARSED_PREFIX = 'parsed_kansei-unicast-other-rows-row1';
%DATA_PARSED_PREFIX = 'parsed_kansei-unicast-other-rows-row2';
%DATA_PARSED_PREFIX = 'parsed_kansei-unicast-other-rows-row3';
%DATA_PARSED_PREFIX = 'parsed_kansei-unicast-other-rows-row4';
%DATA_PARSED_PREFIX = 'parsed_kansei-unicast-other-rows-row5';
%DATA_PARSED_PREFIX = 'parsed_kansei-unicast-other-rows-row6';
%DATA_PARSED_PREFIX = 'parsed_kansei-unicast-other-rows-row8';
%DATA_PARSED_PREFIX = 'parsed_kansei-unicast-other-rows-row9';
%DATA_PARSED_PREFIX = 'parsed_kansei-unicast-other-rows-row10';
%DATA_PARSED_PREFIX = 'parsed_kansei-unicast-other-rows-row11';
%DATA_PARSED_PREFIX = 'parsed_kansei-unicast-other-rows-row12';
%DATA_PARSED_PREFIX = 'parsed_kansei-unicast-other-rows-row13';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-interfer-all';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-interferer-free';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-interfer-sym';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-interfer-far';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-interfer-middle';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-interfer-close';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-interfer-exscal';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-30bytes-interferer-free';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-diffPowerLevels-special-power128';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-diffPowerLevels-special-power148';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-diffPowerLevels-special-power208';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-diffPowerLevels-special-power42';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-diffPowerLevels-power148';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-diffPowerLevels-power168';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-diffPowerLevels-power188';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-diffPowerLevels-power208';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-diffPowerLevels-power228';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-diffPowerLevels-power248';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-diffPowerLevels-power2';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-diffPowerLevels-power22';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-diffPowerLevels-power42';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-diffPowerLevels-power82';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-diffPowerLevels-power102';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-diffPowerLevels-power122';
%DATA_PARSED_PREFIX = 'parsed_kansei-broadcast-diffPowerLevels-power127';
%DATA_PARSED_PREFIX = 'kansei-mote-broadcast-power3-data';
%DATA_PARSED_PREFIX = 'kansei-mote-broadcast-power6-data';
%DATA_PARSED_PREFIX = 'kansei-mote-broadcast-power9-data';
%DATA_PARSED_PREFIX = 'parsed-kansei-xsm-unicast-power3-03-12-07a-noMacLatency-unicast';
%DATA_PARSED_PREFIX = 'parsed-kansei-xsm-broadcast-power3-LM-xsm-interferer-free';
%DATA_PARSED_PREFIX = 'parsed-kansei-xsm-broadcast-power3-LM-xsm-interferer-close';
%DATA_PARSED_PREFIX = 'parsed-kansei-xsm-broadcast-power3-LM-xsm-interferer-middle';
%DATA_PARSED_PREFIX = 'parsed-kansei-xsm-broadcast-power3-LM-xsm-interferer-far';
%DATA_PARSED_PREFIX = 'parsed-kansei-xsm-unicast-power3-diagonal-12';
%DATA_PARSED_PREFIX = 'parsed-kansei-xsm-broadcast-power3-interferer-free-diagonal-12';
%DATA_PARSED_PREFIX = 'parsed-kansei-xsm-unicast-power3-LM-xsm-unicast-12-free';
%DATA_PARSED_PREFIX = 'parsed-kansei-xsm-unicast-power3-LM-xsm-unicast-12-close';
%DATA_PARSED_PREFIX = 'parsed-kansei-xsm-unicast-power3-LM-xsm-unicast-12-middle';
%DATA_PARSED_PREFIX = 'parsed-kansei-xsm-unicast-power3-LM-xsm-unicast-12-far';
%DATA_PARSED_PREFIX = 'parsed-kansei-xsm-broadcast-power3-xsm-interferer-free';
%DATA_PARSED_PREFIX = 'parsed-kansei-xsm-broadcast-power3-xsm-interferer-close';
%DATA_PARSED_PREFIX = 'parsed-kansei-xsm-broadcast-power3-xsm-interferer-middle';
%DATA_PARSED_PREFIX = 'parsed-kansei-xsm-broadcast-power3-xsm-interferer-far';
%DATA_PARSED_PREFIX = 'parsed-kansei-xsm-broadcast-power2-xsm-interferer-free';
DATA_PARSED_PREFIX = 'parsed-kansei-xsm-broadcast-power1-xsm-interferer-free';

X_AS_Y_COORDINATE = 0;%1; %1: yes     0: no        ; after kansei
Y_DISTS_ABS = [0 1 2 3 4 5 6];%1 2 3 4 5 6]; %absolute distances along y-axis
NODES_HAVING_INCORRECT_LOCATION = [];%[221];%221 is semi-location error;
                                        %%avon park only: [204];

HAS_MAC_LATENCY_DATA = 1; %0: no      1: yes

ORGNIZED_FILE_SUFFIX = '.mat';
PARSED_FILE_SUFFIX = '.mat';
ID_DISTANCE_PKTTYPE_FILE = 'id.distance.broadcast-unicast.txt';

PKT_SIZES = [30];% 1200]; %bytes
PKT_PERIOD_LEN = [100000 10000 1000 100 10]; %number of packets
TIME_PERIOD_LEN = [60000000 1000000 500000 100000]; %microseconds

BROADCAST = 0;
UNICAST = 1;
PKT_TYPES = [BROADCAST UNICAST]; %0: is broadcast     1: unicast

RECEIVED_MARK = 0;
LOST_MARK = -4;

MAC_FB_SUCC = 1;
MAC_FB_FAIL = -1;
STATUS_NOT_FOUND_MARK = -2; %no MAC feedback

for yDistIndex = 1:length(Y_DISTS_ABS) 
    disp('   ');
    disp(['Processing' '  ABS-Y-DIST = ' num2str(Y_DISTS_ABS(yDistIndex)) '  ...']);
    
    %to save memory
    clear idDistPktTypeFile idDistPktType idDistPktType distances exptFiles;

    %find the set of id-distances-type mapping
    if ~USE_UNIX_MATLAB
        idDistPktTypeFile = [rootDir '\' ID_DISTANCE_PKTTYPE_FILE];
    else 
        idDistPktTypeFile = [rootDir '/' ID_DISTANCE_PKTTYPE_FILE];
    end
    if exist(idDistPktTypeFile) ~= 0 %the file exists
        idDistPktType = load(idDistPktTypeFile); %Format: id  distance(feet) pkt-type
    else
        %compose the mapping automatically
        idDistPktType = [];
        exptFiles = dir(rootDir);
        for fileIndex = 1:length(exptFiles)
            indexedFile = exptFiles(fileIndex).name;
            %skip directories ., .., and files whose file names do not start with ORGNIZED_FILE_PREFIX
            if strcmp(indexedFile, '.') || strcmp(indexedFile, '..') || exptFiles(fileIndex).isdir ...
                    || isempty(strfind(indexedFile, ORGNIZED_FILE_PREFIX))
                continue
            end
            %fetch the file
            if ~USE_UNIX_MATLAB
                content = load([rootDir '\' indexedFile]);
            else
                content = load([rootDir '/' indexedFile]);
            end
            %only consider nodes of certain y-dist-abs or x-dist-abs
            if X_AS_Y_COORDINATE == 1
                considerThisFile = abs(content.receiverDistX(1)) == Y_DISTS_ABS(yDistIndex);
            else
                considerThisFile = abs(content.receiverDistY(1)) == Y_DISTS_ABS(yDistIndex);
            end
            if considerThisFile             
                %get the id, distance, type(s), and update idDistPktType accordingly            
                id = content.receiverId(1);
                if ~isempty(find(content.isBroadcast ~= BROADCAST)) %there is unicast packets
                    if isempty(idDistPktType) || ...
                       isempty(intersect(find(idDistPktType(:, 1) == id), find(idDistPktType(:, 3) == UNICAST))) %a node-pkt_type pair is newly found
                        len = size(idDistPktType, 1);
                        idDistPktType(len+1, 1) = id;
                        idDistPktType(len+1, 2) = content.receiverDist(1);
                        idDistPktType(len+1, 3) = UNICAST;
                    end            
                elseif ~isempty(find(content.isBroadcast == BROADCAST)) %there is broadcast packets
                    if isempty(idDistPktType) || ...
                       isempty(intersect(find(idDistPktType(:, 1) == id), find(idDistPktType(:, 3) == BROADCAST))) %a node-pkt_type pair is newly found
                        len = size(idDistPktType, 1);
                        idDistPktType(len+1, 1) = id;
                        idDistPktType(len+1, 2) = content.receiverDist(1);
                        idDistPktType(len+1, 3) = BROADCAST;
                    end
                end
            end
            %to save memory
            clear content;
        end
    end
    if ~isempty(idDistPktType)
        idDistPktType = sortrows(idDistPktType, [3 2])
        distances = unique(idDistPktType(:, 2));
    else
        disp('  no corresponding data files, done');
        continue;
    end
    
    %summarize the data regarding each packet type, each packet size, as well
    %as each distance value
    for pktTypeIndex = 1:length(PKT_TYPES) %broadcast, unicast
        for pktSizeIndex = 1:length(PKT_SIZES)
            disp(['Processing' '  pkt-type = ' num2str(PKT_TYPES(pktTypeIndex)) '   pkt-size = ' num2str(PKT_SIZES(pktSizeIndex)) ': please wait ...']);
            for distIndex = 1:length(distances)
                disp(['   - processing y-dist-abs = ' num2str(Y_DISTS_ABS(yDistIndex)) ... 
                                       '    distance = ' num2str(distances(distIndex)) ': please wait ...']);
                %initialized the various fields
                sumData.distance = distances(distIndex);
                sumData.deliveryRatePktPeriod = [];
                sumData.deliveryRateTimePeriod = [];
                sumData.lenSuccessBursts = [];
                sumData.lenFailureBursts = [];
                sumData.fbDelaySucc = [];
                sumData.macLatencyAll = [];
                sumData.macLatencySucc = [];
                sumData.fbDelayFail = [];
                sumData.macLatencyFail = [];
                sumData.fbDelayBC = [];
                sumData.macLatencyBC = [];
                
                %to save memory
                clear organizedDataFile organizedData indices ...
                isReceivedList sendingTimeList fbTimeList statusList macLatencyList
                %To find the organized-file/data regarding the related packets sent: type, distance, size
                clear distanceIndices pktTypeIndices id type
                % a) find the node id
                distanceIndices = find(idDistPktType(:, 2) == distances(distIndex));
                pktTypeIdices = find(idDistPktType(:, 3) == PKT_TYPES(pktTypeIndex));
                id = idDistPktType(intersect(distanceIndices, pktTypeIdices), 1);
                if isempty(id)
                    disp('        no node corresponds to this distance, packet type, done!');
                    continue
                elseif length(id) > 1
                    %need to pick the correct node
                    id = setdiff(id, NODES_HAVING_INCORRECT_LOCATION);
                    id = id(1); %stabilization
                end
                % b) formulate the filename for the corresponding organized data
                if PKT_TYPES(pktTypeIndex) == BROADCAST 
                    type = 'broadcast';
                else
                    type = 'unicast';
                end            
                if ~USE_UNIX_MATLAB
                    organizedDataFile = [rootDir '\' ORGNIZED_FILE_PREFIX '-' type '-' num2str(id) ORGNIZED_FILE_SUFFIX];
                else                 
                    organizedDataFile = [rootDir '/' ORGNIZED_FILE_PREFIX '-' type '-' num2str(id) ORGNIZED_FILE_SUFFIX];
                end
                % c) load the data
                disp(['       loading data file: ' ORGNIZED_FILE_PREFIX '-' type '-' num2str(id) ORGNIZED_FILE_SUFFIX]); 
                if exist(organizedDataFile) ~= 0
                    organizedData = load(organizedDataFile);
                else 
                    disp('        no data regarding this distance');
                    continue;
                end
                
                %To fetch the data required: by pkt-size ... 
                indices = find(organizedData.pktSize == PKT_SIZES(pktSizeIndex));
                %isReceived sublist for this parameter set
                isReceivedList = organizedData.isReceived(indices);
                %disp(['length(isReceivedList) = ' num2str(length(isReceivedList))]);
                if isempty(isReceivedList)  %skip empty cases
                    disp('        no data regarding this distance');
                    continue
                end
                %find the corresponding sending time for these packets
                sendingTimeList = organizedData.sendingTime(indices); %microseconds
                %find the corresponding feedback delay as well as feedback status for these packets
                %             disp(['length(fbTime) = ' num2str(length(organizedData.fbTime))]);
                fbTimeList = organizedData.fbTime(indices);
                statusList = organizedData.status(indices);
                if HAS_MAC_LATENCY_DATA == 1
                    macLatencyList = organizedData.macLatency(indices);
                    for indAll = 1:length(macLatencyList)
                        sumData.macLatencyAll(indAll, 1) = PKT_TYPES(pktTypeIndex); %packet type
                        sumData.macLatencyAll(indAll, 2) = PKT_SIZES(pktSizeIndex); %packet size
                        sumData.macLatencyAll(indAll, 3) = macLatencyList(indAll); %latency
                        sumData.macLatencyAll(indAll, 4) = statusList(indAll); %status: 1, -1
                    end
                end
                %clean up the organized data            
                %             disp(['        sendingTime: issorted = ' num2str(issorted(organizedData.sendingTime))]);
                %             disp(['        indices: issorted = ' num2str(issorted(indices))]);
                %             disp(['        sendingTimeList: issorted = ' num2str(issorted(sendingTimeList))]);
                if ~issorted(sendingTimeList)
                    epochBase = 0;
                    for i = 2:length(sendingTimeList)
                        if sendingTimeList(i-1) > sendingTimeList(i)
                            %disp(['sendingTimeList unsorted at ' num2str(i) 'th item: ' num2str(sendingTimeList(i-1)) '>' num2str(sendingTimeList(i))]) ;
                            if epochBase == 0 || (sendingTimeList(i-1) - epochBase) > sendingTimeList(i)
                                epochBase = sendingTimeList(i-1);
                            end
                            sendingTimeList(i) = sendingTimeList(i) + epochBase;
                            fbTimeList(i) = fbTimeList(i) + epochBase;
                        else 
                            epochBase = 0;
                        end
                    end
                    clear epochBase;
                end
                %             disp(['        sendingTimeList: issorted = ' num2str(issorted(sendingTimeList))]);
                
                
                %--------------------------------
                %the summarized data for each distance is indexed by: "pktType   pktSize ..."
                
                %--------------------------------------------------------------
                % 1) calculate delivery rate with different "packets period":
                %      using vector isReceivedList;
                %
                %    And store the calculated data to sumData.deliveryRatePktPeriod
                %    
                %    Format: pacekt-type  packet-size   packt-period length   delivery-rate
                
                for lenIndex = 1:length(PKT_PERIOD_LEN)
                    %for a specific type of packet-period-length
                    for curPeriod = 1:floor(length(isReceivedList)/PKT_PERIOD_LEN(lenIndex))
                        sublist = isReceivedList(((curPeriod-1) * PKT_PERIOD_LEN(lenIndex) + 1): ...
                            (curPeriod * PKT_PERIOD_LEN(lenIndex)) ...
                            );
                        numReceived = length(find(sublist == RECEIVED_MARK));
                        %record the data
                        len = size(sumData.deliveryRatePktPeriod, 1);
                        sumData.deliveryRatePktPeriod(len+1, 1) = PKT_TYPES(pktTypeIndex); %packet type
                        sumData.deliveryRatePktPeriod(len+1, 2) = PKT_SIZES(pktSizeIndex); %packet size
                        sumData.deliveryRatePktPeriod(len+1, 3) = PKT_PERIOD_LEN(lenIndex); %len of packet period
                        sumData.deliveryRatePktPeriod(len+1, 4) = numReceived/PKT_PERIOD_LEN(lenIndex); %delivery rate
                    end
                    curPeriod = floor(length(isReceivedList)/PKT_PERIOD_LEN(lenIndex));
                    if mod(length(isReceivedList), PKT_PERIOD_LEN(lenIndex)) ~= 0 %the resmaining partial-period
                        sublist = isReceivedList(((curPeriod * PKT_PERIOD_LEN(lenIndex)) + 1):...
                            length(isReceivedList)...
                            );
                        if isempty(sublist)
                            continue
                        end
                        numReceived = length(find(sublist == RECEIVED_MARK));                    
                        %record the data
                        len = size(sumData.deliveryRatePktPeriod, 1);
                        sumData.deliveryRatePktPeriod(len+1, 1) = PKT_TYPES(pktTypeIndex); %packet type
                        sumData.deliveryRatePktPeriod(len+1, 2) = PKT_SIZES(pktSizeIndex); %packet size
                        sumData.deliveryRatePktPeriod(len+1, 3) = PKT_PERIOD_LEN(lenIndex); %len of packet period
                        sumData.deliveryRatePktPeriod(len+1, 4) = numReceived/length(sublist); %delivery rate
                    end
                end
                %to save memory
                clear sublist len numReceived curPeriod
                disp('      ... in progress ...');
                
                
                %--------------------------------------------------------------
                % 2) calculate delivery rate with different "packets period":
                %      using vectors sendingTimeList & isReceivedList;
                %
                %    And store the calculated data to sumData.deliveryRateTimePeriod
                %            
                %    Format: pacekt-type  packet-size   time-period length   delivery-rate
                
                for lenIndex = 1:length(TIME_PERIOD_LEN)
                    %for a specific type of time-period-length
                    for curPeriod = 1:floor((sendingTimeList(length(isReceivedList)) - sendingTimeList(1))/...
                            TIME_PERIOD_LEN(lenIndex)...
                            ) 
                        sublistIndices = intersect(find(sendingTimeList >= (sendingTimeList(1) + (curPeriod-1)*TIME_PERIOD_LEN(lenIndex))),...
                            find(sendingTimeList < (sendingTimeList(1) + curPeriod*TIME_PERIOD_LEN(lenIndex)))...
                            );
                        if isempty(sublistIndices)
                            continue
                        end
                        sublist = isReceivedList(sublistIndices);
                        numReceived = length(find(sublist == RECEIVED_MARK));
                        %record the data
                        len = size(sumData.deliveryRateTimePeriod, 1);
                        sumData.deliveryRateTimePeriod(len+1, 1) = PKT_TYPES(pktTypeIndex); %packet type
                        sumData.deliveryRateTimePeriod(len+1, 2) = PKT_SIZES(pktSizeIndex); %packet size
                        sumData.deliveryRateTimePeriod(len+1, 3) = TIME_PERIOD_LEN(lenIndex); %len of time period                    
                        sumData.deliveryRateTimePeriod(len+1, 4) = numReceived/length(sublist); %delivery rate
                    end
                    if floor((sendingTimeList(length(isReceivedList)) - sendingTimeList(1))/TIME_PERIOD_LEN(lenIndex)...
                            ) < 1    %make sure curPeriod is assigned (positive) value
                        curPeriod = 1;
                    end
                    if mod((sendingTimeList(length(isReceivedList)) - sendingTimeList(1)), TIME_PERIOD_LEN(lenIndex)) ~= 0 
                        %the resmaining partial-period                                                                                     
                        sublistIndices = find(sendingTimeList >= (sendingTimeList(1) + curPeriod*TIME_PERIOD_LEN(lenIndex)));
                        if ~isempty(sublistIndices)
                            sublist = isReceivedList(sublistIndices);                        
                            numReceived = length(find(sublist == RECEIVED_MARK));                    
                            %record the data
                            len = size(sumData.deliveryRateTimePeriod, 1);
                            sumData.deliveryRateTimePeriod(len+1, 1) = PKT_TYPES(pktTypeIndex); %packet type
                            sumData.deliveryRateTimePeriod(len+1, 2) = PKT_SIZES(pktSizeIndex); %packet size
                            sumData.deliveryRateTimePeriod(len+1, 3) = TIME_PERIOD_LEN(lenIndex); %len of time period                    
                            sumData.deliveryRateTimePeriod(len+1, 4) = numReceived/length(sublist); %delivery rate
                        end
                    end
                end
                %to save memory
                clear sublistIndices sublist len curPeriod numReceived 
                disp('      ... in progress ...');
                
                
                %--------------------------------------------------------------
                % 3,4) calculate success-burst-lengths and failure-burst-lengths:
                %         using vectors isReceivedList and sendingTimeList;
                %
                %    And store the result into sumData.lenSuccessBursts & sumData.lenFailureBursts
                %
                %    Format: pacekt-type  packet-size   len-in-#-of-packets   len-in-time
                curBurstLen = 1;
                startPos = 1;
                if length(isReceivedList) < 2
                    warning('fewer than 2 packets are sent');
                    return;
                end
                for index = 2:length(isReceivedList)
                    if isReceivedList(index) == isReceivedList(index-1)
                        curBurstLen = curBurstLen + 1;
                    else
                        stopPos = index-1;
                        if isReceivedList(index-1) == RECEIVED_MARK
                            len = size(sumData.lenSuccessBursts, 1);
                            sumData.lenSuccessBursts(len+1, 1) = PKT_TYPES(pktTypeIndex); %packt type
                            sumData.lenSuccessBursts(len+1, 2) = PKT_SIZES(pktSizeIndex); %packet size
                            sumData.lenSuccessBursts(len+1, 3) = curBurstLen; %burst length: # of packets
                            sumData.lenSuccessBursts(len+1, 4) = sendingTimeList(stopPos) - ...
                                sendingTimeList(startPos); %burst length: time (microseconds)                        
                        else 
                            len = size(sumData.lenFailureBursts, 1);
                            sumData.lenFailureBursts(len+1, 1) = PKT_TYPES(pktTypeIndex); %packt type
                            sumData.lenFailureBursts(len+1, 2) = PKT_SIZES(pktSizeIndex); %packet size
                            sumData.lenFailureBursts(len+1, 3) = curBurstLen; %burst length: # of packets
                            sumData.lenFailureBursts(len+1, 4) = sendingTimeList(stopPos) - ...
                                sendingTimeList(startPos); %burst length: time (microseconds)                                               
                        end
                        curBurstLen = 1;
                        startPos = index;
                    end
                    %process the last burst
                    stopPos = index; 
                    if isReceivedList(index) == RECEIVED_MARK
                        len = size(sumData.lenSuccessBursts, 1);
                        sumData.lenSuccessBursts(len+1, 1) = PKT_TYPES(pktTypeIndex); %packt type
                        sumData.lenSuccessBursts(len+1, 2) = PKT_SIZES(pktSizeIndex); %packet size
                        sumData.lenSuccessBursts(len+1, 3) = curBurstLen; %burst length: # of packets
                        sumData.lenSuccessBursts(len+1, 4) = sendingTimeList(stopPos) - ...
                            sendingTimeList(startPos); %burst length: time (microseconds)                        
                    else 
                        len = size(sumData.lenFailureBursts, 1);
                        sumData.lenFailureBursts(len+1, 1) = PKT_TYPES(pktTypeIndex); %packt type
                        sumData.lenFailureBursts(len+1, 2) = PKT_SIZES(pktSizeIndex); %packet size
                        sumData.lenFailureBursts(len+1, 3) = curBurstLen; %burst length: # of packets
                        sumData.lenFailureBursts(len+1, 4) = sendingTimeList(stopPos) - ...
                            sendingTimeList(startPos); %burst length: time (microseconds)                                               
                    end
                end
                %to save memory
                clear startPos stopPos curBurstLen len index
                disp('      ... in progress ...');
                
                
                %--------------------------------------------------------------
                % 5) calculate the feedback time as well as mac-latency for successful unicast
                %         using vectors fbTimeList, sendingTimeList, statusList, and macLatencyList
                %
                %    And store the result into sumData.fbDelaySucc & sumData.macLatencySucc
                %
                %    Format: packet-size   fb-time/mac-latency(microseconds)
                
                statusIndices = find(statusList == MAC_FB_SUCC);
                %fbDelaySucc
                if PKT_TYPES(pktTypeIndex) ~= BROADCAST && ~isempty(statusIndices)
                    toPresent = fbTimeList(statusIndices) - sendingTimeList(statusIndices);
                    if ~isempty(toPresent)
                        len = size(sumData.fbDelaySucc, 1);
                        for index=1:length(toPresent)
                            sumData.fbDelaySucc(len+index, 1) = PKT_TYPES(pktTypeIndex); %packet type
                            sumData.fbDelaySucc(len+index, 2) = PKT_SIZES(pktSizeIndex); %packet size
                            sumData.fbDelaySucc(len+index, 3) = toPresent(index); %feedback delay; microseconds
                        end
                    end
                    clear toPresent index
                    %macLatencySucc
                    if HAS_MAC_LATENCY_DATA == 1
                        toPresent = macLatencyList(statusIndices);
                        if ~isempty(toPresent)
                            len = size(sumData.macLatencySucc, 1);
                            for index=1:length(toPresent)
                                sumData.macLatencySucc(len+index, 1) = PKT_TYPES(pktTypeIndex); %packet type
                                sumData.macLatencySucc(len+index, 2) = PKT_SIZES(pktSizeIndex); %packet size
                                sumData.macLatencySucc(len+index, 3) = toPresent(index); %mac latency: microseconds
                            end
                        end            
                    end         
                end
                %to save memory
                clear statusIndices toPresent len index
                disp('      ... in progress ...');
                
                
                %--------------------------------------------------------------
                % 6) calculate the feedback time and mac-latency for failed unicast
                %         using vectors fbTimeList, sendingTimeList, statusList, and macLatencyList 
                %
                %    And store the result into sumData.fbDelayFail & sumData.macLatencyFail
                %
                %    Format: packet-size   fb-time/macLatnecy(microseconds)
                
                statusIndices = find(statusList == MAC_FB_FAIL);
                if PKT_TYPES(pktTypeIndex) ~= BROADCAST && ~isempty(statusIndices)
                    %fbDelayFail
                    toPresent = fbTimeList(statusIndices) - sendingTimeList(statusIndices);
                    if ~isempty(toPresent)
                        len = size(sumData.fbDelayFail, 1);
                        for index=1:length(toPresent)
                            sumData.fbDelayFail(len+index, 1) = PKT_TYPES(pktTypeIndex); %packet type
                            sumData.fbDelayFail(len+index, 2) = PKT_SIZES(pktSizeIndex); %packet size                    
                            sumData.fbDelayFail(len+index, 3) = toPresent(index); %feedback delay; microseconds
                        end
                    end    
                    clear toPresent index                
                    %macLatencyFail
                    if HAS_MAC_LATENCY_DATA == 1
                        toPresent = macLatencyList(statusIndices);
                        if ~isempty(toPresent)
                            len = size(sumData.macLatencyFail, 1);
                            for index=1:length(toPresent)
                                sumData.macLatencyFail(len+index, 1) = PKT_TYPES(pktTypeIndex); %packet type
                                sumData.macLatencyFail(len+index, 2) = PKT_SIZES(pktSizeIndex); %packet size
                                sumData.macLatencyFail(len+index, 3) = toPresent(index); %mac latency: microseconds
                            end
                        end            
                    end
                end
                %to save memory
                clear statusIndices toPresent len
                
                %--------------------------------------------------------------
                % 7) calculate the feedback time and mac-latency for broadcast
                %         using vectors fbTimeList, sendingTimeList, statusList, and macLatencyList 
                %
                %    And store the result into sumData.fbDelayBC & sumData.macLatencyBC
                %
                %    Format: packet-size   fb-time/macLatnecy(microseconds)
                
                if PKT_TYPES(pktTypeIndex) == BROADCAST
                    %statusIndices = find(statusList == MAC_FB_SUCC); %always succ for broadcast
                    %fbDelayBC
                    toPresent = fbTimeList - sendingTimeList;
                    if ~isempty(toPresent)
                        len = size(sumData.fbDelayBC, 1);
                        for index=1:length(toPresent)
                            sumData.fbDelayBC(len+index, 1) = PKT_TYPES(pktTypeIndex); %packet type
                            sumData.fbDelayBC(len+index, 2) = PKT_SIZES(pktSizeIndex); %packet size                    
                            sumData.fbDelayBC(len+index, 3) = toPresent(index); %feedback delay; microseconds
                        end
                    end    
                    clear toPresent index                
                    %macLatencyBC
                    if HAS_MAC_LATENCY_DATA == 1
                        toPresent = macLatencyList;
                        if ~isempty(toPresent)
                            len = size(sumData.macLatencyBC, 1);
                            for index=1:length(toPresent)
                                sumData.macLatencyBC(len+index, 1) = PKT_TYPES(pktTypeIndex); %packet type
                                sumData.macLatencyBC(len+index, 2) = PKT_SIZES(pktSizeIndex); %packet size
                                sumData.macLatencyBC(len+index, 3) = toPresent(index); %mac latency: microseconds
                            end
                        end            
                    end
                end
                %to save memory
                clear statusIndices toPresent len
                
                %Save the data for this distance, packet size, and packet type
                DATA_PARSED = [DATA_PARSED_PREFIX '_' num2str(Y_DISTS_ABS(yDistIndex)) '_' num2str(distances(distIndex))]; %attach the distance values to the filename
                DATA_PARSED = [DATA_PARSED '_' num2str(PKT_SIZES(pktSizeIndex)) '_' num2str(PKT_TYPES(pktTypeIndex))]; %attach the packet size and packet size            
                DATA_PARSED = [DATA_PARSED PARSED_FILE_SUFFIX];
                save(DATA_PARSED, 'sumData');
                disp(['     processing y-dist-abs = ' num2str(Y_DISTS_ABS(yDistIndex)) ...
                                       '   distance = ' num2str(distances(distIndex)) ': done!']);
                
                %to save memory and improve performance
                clear sumData
                pack 
            end %by distances
            disp(['  pkt-type = ' num2str(PKT_TYPES(pktTypeIndex)) '   pkt-size = ' num2str(PKT_SIZES(pktSizeIndex)) ': done!']);
        end %by packet sizes
    end %by packet types

end %by Y_DISTS_ABS

disp('dataParser: DONE!!!')
